<?php

/* disable caching */
header('Cache-Control: no-cache');
header('Pragma: no-cache');
header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');

/* counter is included as image */
header('Content-type: image/png');

/* connect to database */
require_once('../../../config.inc');
require_once('../../../_include/common/mysql/default.php');
require_once('charconvert/autoczech.php');

/* and eregi(no_Referer, $HTTP_REFERER) - counter can be caller only from your own pages */

  /* date */
  $date = date('Y-m-d H:i:s');

  /* visit - unique visitor (cookie is valid only today) */
  setcookie('visit', 'PAGEVIEW', mktime(23,59,59, date('m'), date('d'), date('Y')), '/');

  /* detecting IP address */
  if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) 
  { /* applied when computer is behind proxy server */
    $explode_ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
    $ip = $explode_ip[0];
  } 
  else 
  {
    $ip = $_SERVER['REMOTE_ADDR'];
  }

  /* if exists cookie "visit", this is not a visit
   * otherwise, detect if this IP address has access in last 15 minutes; if no, this is a visit */
  if(isset($_COOKIE['visit'])) 
  {
    $visit = 0;
  } 
  else 
  {
    $query = "SELECT date FROM `".DB_STAT."`.access WHERE ip = '$ip' AND DATE_ADD(date, INTERVAL 15 MINUTE) > NOW() LIMIT 0,1";
    $exec  = @mysqli_query($db, $query);
    if ($result = @mysqli_fetch_array($exec))
    {
      $visit = 0;
    }  
    else
    {
      $visit = 1;
    }  
  }
  
  $http_user_agent = strtolower($_SERVER['HTTP_USER_AGENT']);
  
  /* detect computer specific information (browser, operating system, resolution, color depth) 
   * 0 stands for "unknown" */
  
  /* browser */
  $query = "SELECT id FROM `".DB_STAT."`.browser WHERE '".$http_user_agent."' REGEXP browser_regexp ORDER BY id LIMIT 0,1";
  $exec  = @mysqli_query($db, $query);
  if ($result = @mysqli_fetch_array($exec))
  {
    $browser = $result['id'];
  }  
  else
  {
    $browser = 0;
  }  
    
  /* operating system */
  $query = "SELECT id FROM `".DB_STAT."`.os WHERE '$http_user_agent' REGEXP os_regexp ORDER BY id LIMIT 0,1";
  $exec  = @mysqli_query($db, $query);
  if ($result = @mysqli_fetch_array($exec))
  {
    $os = $result['id'];
  }  
  else
  {
    $os = 0;
  }  

  /* resolution */
  $resolution = 0;
  if (isset($_GET['screenres'])) 
  {
    $screenres = addslashes($_GET['screenres']);
    $query = "SELECT id FROM `".DB_STAT."`.resolution WHERE screenres = '$screenres'";
    $exec  = @mysqli_query($db, $query);
    if ($result = @mysqli_fetch_array($exec))
    {
      $resolution = $result['id'];
    }  
  }
  
  // webpart
  $wp_q = "SELECT id FROM `".DB_STAT."`.webpartN 
           WHERE server = '".$_GET['server']."' && 
                 p1 = '".$_GET['p1']."' && 
                 p2 = '".$_GET['p2']."' && 
                 p3 = '".$_GET['p3']."' &&
                 p4 = '".$_GET['p4']."'";
  $wp_e = @mysqli_query($db, $wp_q);
  if($wp_r = @mysqli_fetch_array($wp_e)) {
    // record for this page is in DB
    $webpart = $wp_r['id'];
  } else {
    $wpi_q = "INSERT INTO `".DB_STAT."`.webpartN SET server = '".$_GET['server']."', p1 = '".$_GET['p1']."', p2 = '".$_GET['p2']."',
                                                     p3 = '".$_GET['p3']."', p4 = '".$_GET['p4']."'";
    $wpi_e = @mysqli_query($db, $wpi_q);
    
    $webpart = @mysqli_insert_id($db);
  }         

  /* color depth */
  $depth = 0;
  if (isset($_GET['colordepth'])) 
  {
    $colordepth = addslashes($_GET['colordepth']);
    $query = "SELECT id FROM `".DB_STAT."`.colordepth WHERE depth = '$colordepth'";
    $exec  = @mysqli_query($db, $query);
    if ($result = @mysqli_fetch_array($exec))
    {
      $depth = $result['id'];
    }  
  }
  
  /* referer */
  $referer = 2; /* from our server */

  if(isset($_GET['referer'])) 
  {
    $escape = array   ('%u010C', '%u010E', '%u011A', '%u0147', '%u0158',
                       '%u0160', '%u0164', '%u016E', '%u017D', '%u010D',
                       '%u010F', '%u011B', '%u0148', '%u0159', '%u0161',
                       '%u0165', '%u016F', '%u017E', '%u0105', '%u013E' ); 
  
    $unescape = array ('', '', '', '', '',
                       '', '', '', '', '',
                       '', '', '', '', '',
                       '', '', '', '', '' );

    /* decode URL and convert to lowercase */ 
    //$http_referer = str_replace($escape, $unescape, urldecode(addslashes($_GET['referer'])) );
    $http_referer = iconv("utf-8", "iso-8859-2", $_GET['referer']);
    $http_referer = strtolower($http_referer); 
    
    if ($http_referer == '') 
    { /* user typed our address directly */
      $referer = 1;
    } 
    elseif (eregi(NO_REFERER, $http_referer)) 
    { /* from our server */
      $referer = 2;
    } 
    else 
    { /* user comes from another page */
      $url = parse_url($http_referer); /* parse URL */
      $host = eregi_replace("^www\.", "", $url['host']); /* delete www */
    
      /* is page in database, if no, add it */
      $query = "SELECT id FROM `".DB_STAT."`.referer WHERE server = '$host'";
      $exec  = @mysqli_query($db, $query);
      if ($result = @mysqli_fetch_array($exec)) 
      {
        $referer = $result['id'];
      } 
      else 
      {
        $query = "INSERT INTO `".DB_STAT."`.referer VALUES ('', '$host')";
        $exec  = @mysqli_query($db, $query);
        $referer = @mysqli_insert_id($db);
      }
         
      /* search engine: what phrase has been used in search engine */
      $explode = explode('.', $url['host']); /* parse URL into parts */
      $host_domain = $explode[count($explode) - 2] . '.' . $explode[count($explode) - 1]; /* 2nd level domain */
          
      /* is it search engine */
      $query = "SELECT * FROM `".DB_STAT."`.searchengine WHERE server = '$host_domain'";
      $exec  = @mysqli_query($db, $query);
      if ($result = @mysqli_fetch_array($exec)) 
      {
        /* detect search engine URL variable phrase */
        $variables = explode('&', $url['query']);
        for ($i = 0;$i < count($variables);$i++) 
        {
          $explode = explode('=', $variables[$i]);
          if ($explode[0] == $result['variable']) 
          {
            $searchtext = $explode[1]; /* search phrase */
            break;
          }
        }
    
        /* phrase detection successfull? insert data into database */
        if ($searchtext != '') 
        {
          $searchengine = $result['id'];
          
          /* existing record? if no, add it */
          $query = "SELECT id FROM `".DB_STAT."`.searchtext WHERE query = '$searchtext'";
          $exec  = @mysqli_query($db, $query);
          if ($result = @mysqli_fetch_array($exec)) 
          {
            $search_id = $result['id'];
          } 
          else 
          {
            $query = "INSERT INTO `".DB_STAT."`.searchtext VALUES ('', '$searchtext')";
            $exec  = @mysqli_query($db, $query);
            $search_id = @mysqli_insert_id($db);
          }
          
          $query = "INSERT INTO `".DB_STAT."`.searched VALUES ('', '$date', '$searchengine', '".$_GET['server']."', '$search_id')";
          $exec  = @mysqli_query($db, $query);
        }
      }
    }
  }
  
  /* domain address */
  if (isset($_SERVER['REMOTE_HOST']) and $_SERVER['REMOTE_HOST'] != '') 
  {
    $ip_name = $_SERVER['REMOTE_HOST'];
  } 
  else 
  {
    $ip_name = gethostbyaddr($ip);
  }

  $ip_name = strtolower($ip_name);

  // if IP address to domain name translation failed, $ip_name = 0
  if ($ip_name == '')
  {
    $ip_name = 0;
  }  
  elseif (eregi("[[:digit:]]{1,3}\.[[:digit:]]{1,3}\.[[:digit:]]{1,3}\.[[:digit:]]{1,3}", $ip_name))
  {
    $ip_name = 0;
  }  

  /* TLD */
  $domain = 0;
  if($ip_name != '0') 
  {
    /* TLD is the last part of domain address */
    $explode = explode('.', $ip_name);
    $domain = $explode[count($explode)-1];
      
    /* is domain in the database */
    $query = "SELECT id FROM `".DB_STAT."`.domain WHERE code = '$domain'";
    $exec  = @mysqli_query($db, $query);
    if($result = @mysqli_fetch_array($exec))
    {
      $domain = $result['id'];
    }  
    else
    {
      $domain = 0;
    }  
  }

  /* region */
  /* search for domain address to database record match */
  $area = 0;
  if ($ip_name != '0') 
  {
    $query = "SELECT id FROM `".DB_STAT."`.town WHERE '$ip_name' REGEXP ip_regexp ORDER BY id LIMIT 0,1";
    $exec  = @mysqli_query($db, $query);
    if ($result = @mysqli_fetch_array($exec))
    {
      $area = $result['id'];
    }  
    else
    {
      $area = 0;
    }  
  }
  
  $query = "INSERT INTO `".DB_STAT."`.access SET session_id = '".$_GET['session_id']."', server = ".$_GET['server'].", date = '$date', 
                                   visit = '$visit', browser = '$browser', os = '$os', resolution = '$resolution', 
                                   colordepth = '$depth', referer = '$referer', area = '$area', ip = '$ip', 
                                   ip_name = '$ip_name', domain = '$domain', webpart = '".$webpart."'";
  $exec  = @mysqli_query($db, $query);                   

// obrazek (transparentni pozadi)
$img = imagecreate(1,1);
$bgcolor = imagecolorallocate($img, 0, 0, 0);
imagecolortransparent($img, $bgcolor);
imagepng($img);

?>
